% 1D ocean model for calulating 17O-excess profiles.
% The code is provide by the contributors "As Is"
% needs inputs of assumed O2 prodctivity, O2 respiration uptake rates, and
% eddy-turbulence coefficients, as well as gas exchange coefficent
%
% For details see:
% "The effect of vertical turbulent mixing on gross O2 production assessments
%  by the triple isotopic composition of dissolved O2" by
% Eyal Wurgaft, Ofer Shamir and Alon Angert,
% The Freddy & Nadine Herrmann Institute of Earth Sciences
% The Hebrew University of Jerusalem, Jerusalem, Israel.

% Orginal version: Alon Angert, 2002
% Updated version: Alon Angert, 2004
% Current version: Eyal Wurgaft and Alon Angert, 2013


clear all;
nl=32 ; % number of layers. Layer 1=eq with atmos,layer nl = fixed deep ocean values
get_const ;% define constants
get_kappa_simple2 ;% get diffusivity profile
get_GPP_R_simple2 ;% get prodcution and respiration profiles.
get_int ;% get inital profile

kapat=kapat*86400; %m2/s to m2/day

for y=1:1 %years loop (
    if isnan(mean(mean(o2))), 'error!', break, end ;
    md=0 ;
    
    for m=1:12 % run for 12 months
        if isnan(mean(mean(o2))), break, end ;
        report_int=days(m)  ; % days to run until output
        
        for dd=1:report_int %
            if isnan(mean(mean(o2))), break, end ;
            t=md+dd ;
            
            % respiration calc
            R1=squeeze(R(:,:,m)) ;
            resp(:,1)=R1(:,1);
            resp(:,2)=R1(:,2).*(o2(:,2)./o2(:,1));
            resp(:,3)=R1(:,3).*(o2(:,3)./o2(:,1));
            resp(1,:)=0;
            resp(nl,:)=0;
            
            photo1=squeeze(photo(:,:,m)) ; % photosynthesis calculation
            
            sum_photo1(:,1)=photo1(:,1)+photo1(:,2)+photo1(:,3);
            sum_photo1(:,2)=sum_photo1(:,1).*10;
            for step=1:(1/DT)
                for z=3:(nl-1); % diffusion fluxes calc. general
                    diff(z,:)=k(z-1,t).*(o2(z-1,:)-o2(z,:))+...
                        k(z,t).*(o2(z+1,:)-o2(z,:));
                end
                % diffusion fluxes calc. gas exchange
                diff(2,1)=k(1,t)*(sat16-o2(2,1))+...
                    k(2,t)*(o2(3,1)-o2(2,1));
                diff(2,2)=k(1,t)*alpha_k18*(sat18-o2(2,2))+...
                    k(2,t)*(o2(3,2)-o2(2,2));
                diff(2,3)=k(1,t)*alpha_k17*(sat17-o2(2,3))+...
                    k(2,t)*(o2(3,3)-o2(2,3));
                
                % o2 iteration
                o2=o2+diff.*DT+photo1.*DT-resp.*DT;
            end
        end
        
        % end profile calc
        
        %calculate profiles
        do18(:,m)=(( o2(:,2)./o2(:,1))./Rhla18-1)*1000;
        D17(:,m)=1e6*(log((o2(:,3)./o2(:,1))./Rhla17)-...
            0.518.*log((o2(:,2)./o2(:,1))./Rhla18));
        bio_s(:,m)=((o2(:,1)./sat16)-1) *100 ;
        o2_m(m,:,:)=o2 ;
        
        md=md+report_int ;
        
        
        % find mixed layer averages
        
        last_layer_ml(1,m)=mix_depths(m+1)/10+1;
        
        
        clear O2_ml
        O2_ml(:,1)=o2(2: last_layer_ml(1,m),1);%16O
        O2_ml(:,3)=o2(2: last_layer_ml(1,m),3);%17O
        O2_ml(:,2)=o2(2: last_layer_ml(1,m),2);%18O
        O2_ml(:,4)=O2_ml(:,3)./O2_ml(:,1); %R17ml
        O2_ml(:,5)=O2_ml(:,2)./O2_ml(:,1); %R18ml
        O2_ml(:,6)= O2_ml(:,4)./Rhla17; %R17/Rhla17
        O2_ml(:,7)= O2_ml(:,5)./Rhla18; %R18/Rhla18
        O2_ml(:,8)=1000000*(log(O2_ml(:,6))-0.518*log(O2_ml(:,7))); %17O/16O
        
        %17D in ML
        D17ml(m)=mean(O2_ml(:,8));
        \1(last_layer_ml(1,m),1)-int_photo1(last_layer_ml(2,m),1))*10;
        GOP_trap(m)=sum( sum_photo1(2: last_layer_ml(1,m),2));
        R17ml= mean(O2_ml(:,4));
        R18ml= mean(O2_ml(:,5));
        
        
        o2eq=o2eq_all(1,m);
        R17eq= R17eq_all(1,m);
        R18eq= R18eq_all(1,m);
        
        
        
        
        
        
        %Luz and Barkan 2000 GOP
        GOP_LUZ(1,m)=4*o2eq*(D17ml(m)-16)/(250-D17ml(m));
        %prokopenko et al 2011 GOP
        
        
        
        a= (R17ml-R17eq)/R17ml;
        b= 0.518*(R18ml-R18eq)/R18ml;
        c=(R17p-R17ml)/R17ml;
        e=0.518*(R18p-R18ml)/R18ml;
        
        GOP_PROKO(1,m)=4*o2eq*(a-b)/(c-e);
        
        %% turbulence corretion
        %get "deep"
        zdeep(1,m)= last_layer_ml(1,m)+1;
        o16deep=(o2(zdeep(m),1));
        o17deep=(o2(zdeep(m),3));
        o18deep=(o2(zdeep(m),2));
        
        O2deep=o16deep+o17deep+o18deep;
        
        R17deep= o17deep/ o16deep;
        R18deep=  o18deep/  o16deep;
        
        %Dee should be kapa/distance between ML base and 'Deep)
        %Dee=kapat/((zdeep(1,m)-1)*10-mix_depths(m+1));
        Dee=kapat/10;
        
        a= (R17ml-R17deep)/R17ml;
        b= 0.518*(R18ml-R18deep)/R18ml;
        
        TURB(1,m)=Dee*O2deep*(a-b)/(c-e);
        D17Odeep(1,m) = (log(R17deep/Rhla17)-0.518*log(R18deep/Rhla18))*1000000;
        
        
        
    end % m loop
    y
end % y loop


summary(1,:)=mix_depths(2:13);

summary(2,:)=  GOP_trap;
summary(3,:)=GOP_LUZ;
summary(4,:)= GOP_PROKO;
summary(5,:)=TURB;
summary(6,:)=summary(4,:)+summary(5,:);%corrected GOP
summary(7,:)=D17Odeep;% D17O deep
summary(8,:)=(summary(4,:)./summary(2,:)-1)*100;%GOP overestimation
cal_plot
